package comparator;
import java.util.Comparator;
import entreprise.Employee;
import entreprise.Agenda;

// OBSERVER BIEN LA CLASSE ANONYME IMBRIQUEE
// static final ==> constante ==> une et une seule instanciation de ces comparateurs
public interface ComparatorEntreprise {
	
	static final Comparator<Employee> AGE_ORDER = new Comparator<Employee>() {
		public int compare(Employee emp1, Employee emp2) {
			int emp1Age = emp1.getAge();        
			int emp2Age = emp2.getAge();

			if(emp1Age > emp2Age)
				return 1;
			else if(emp1Age < emp2Age)
				return -1;
			else
				return 0;    
		}
	};		
	
	static final Comparator<Employee> NAME_ORDER = new Comparator<Employee>() {
		public int compare(Employee emp1, Employee emp2){    
			String emp1Name = emp1.getName();        
			String emp2Name = emp2.getName();

			//uses compareTo method of String class to compare names of the employee
			return emp1Name.compareTo(emp2Name);
		}
	};		
	
	
	static final Comparator<Agenda> EMPLOYEE_SALAIRE_ORDER = new Comparator<Agenda>() {
		public int compare(Agenda agenda1, Agenda agenda2){    
			Employee employe1 = agenda1.getEmploye();
			Employee employe2 = agenda2.getEmploye();
			
			//uses compareTo method of String class to compare names of the employee
			return employe1.compareTo(employe2);
		}
	};		
}

